<?php
require 'config.php';

// Check if admin
if (!isset($_SESSION['user_id']) || !$_SESSION['is_admin']) {
    header('Location: index.php');
    exit;
}

$user_id = $_SESSION['user_id'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard - SourceHub</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            color: #333;
        }
        
        header {
            background: white;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            position: sticky;
            top: 0;
            z-index: 100;
        }
        
        nav {
            max-width: 1200px;
            margin: 0 auto;
            padding: 15px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
        }
        
        .logo {
            font-size: 28px;
            font-weight: bold;
            color: #667eea;
            text-decoration: none;
        }
        
        .nav-links {
            display: flex;
            gap: 20px;
            align-items: center;
            flex-wrap: wrap;
        }
        
        .nav-links a, .nav-links button {
            text-decoration: none;
            color: #333;
            padding: 8px 15px;
            border-radius: 5px;
            border: none;
            cursor: pointer;
            transition: all 0.3s;
            background: none;
            font-size: 14px;
        }
        
        .nav-links a:hover {
            background: #f0f0f0;
        }
        
        .btn-logout {
            background: #e74c3c;
            color: white;
        }
        
        .btn-logout:hover {
            background: #c0392b;
        }
        
        .user-welcome {
            color: white;
            font-weight: bold;
            background: #667eea;
            padding: 8px 15px;
            border-radius: 5px;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }
        
        h1 {
            color: white;
            margin-bottom: 30px;
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 40px;
        }
        
        .stat-card {
            padding: 30px;
            border-radius: 10px;
            text-align: center;
            color: white;
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
        }
        
        .stat-card h3 {
            font-size: 40px;
            margin-bottom: 10px;
            font-weight: bold;
        }
        
        .stat-card p {
            font-size: 16px;
            opacity: 0.95;
        }
        
        .stat-users {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        
        .stat-projects {
            background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
        }
        
        .stat-orders {
            background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
        }
        
        .stat-revenue {
            background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);
        }
        
        .admin-panel {
            background: white;
            border-radius: 10px;
            padding: 30px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
            margin-bottom: 30px;
        }
        
        .admin-panel h2 {
            color: #2c3e50;
            margin-bottom: 20px;
            border-bottom: 2px solid #667eea;
            padding-bottom: 15px;
        }
        
        .admin-table {
            width: 100%;
            border-collapse: collapse;
        }
        
        .admin-table th {
            background: #f8f9fa;
            color: #2c3e50;
            padding: 15px;
            text-align: left;
            font-weight: bold;
            border-bottom: 2px solid #ecf0f1;
        }
        
        .admin-table td {
            padding: 15px;
            border-bottom: 1px solid #ecf0f1;
        }
        
        .admin-table tr:hover {
            background: #f8f9fa;
        }
        
        .status-badge {
            padding: 6px 12px;
            border-radius: 3px;
            font-weight: bold;
            display: inline-block;
            font-size: 13px;
        }
        
        .status-success {
            background: #d5f4e6;
            color: #27ae60;
        }
        
        .status-pending {
            background: #fef5e7;
            color: #f39c12;
        }
        
        .footer {
            background: #2c3e50;
            color: white;
            text-align: center;
            padding: 20px;
            margin-top: 40px;
        }
        
        @media (max-width: 768px) {
            .stats-grid {
                grid-template-columns: 1fr;
            }
            
            .admin-table {
                font-size: 13px;
            }
            
            .admin-table th,
            .admin-table td {
                padding: 10px;
            }
            
            nav {
                flex-direction: column;
                gap: 15px;
            }
            
            .nav-links {
                width: 100%;
                justify-content: center;
            }
        }
    </style>
</head>
<body>
    <header>
        <nav>
            <a href="index.php" class="logo">🚀 SourceHub</a>
            <div class="nav-links">
                <a href="index.php">Home</a>
                <a href="projects.php">Projects</a>
                <a href="dashboard.php">Dashboard</a>
                <a href="admin.php" style="color: #f39c12; font-weight: bold;">🔒 Admin</a>
                <span class="user-welcome">👤 <?php echo htmlspecialchars($_SESSION['user_name']); ?></span>
                <button class="btn-logout" onclick="window.location.href='logout.php'">Logout</button>
            </div>
        </nav>
    </header>

    <div class="container">
        <h1>🔒 Admin Dashboard</h1>
        
        <!-- STATISTICS -->
        <div class="stats-grid">
            <?php
            $total_users = $conn->query("SELECT COUNT(*) as count FROM users")->fetch_assoc()['count'];
            $total_projects = $conn->query("SELECT COUNT(*) as count FROM projects")->fetch_assoc()['count'];
            $total_orders = $conn->query("SELECT COUNT(*) as count FROM orders")->fetch_assoc()['count'];
            $total_revenue = $conn->query("SELECT SUM(amount) as sum FROM orders WHERE status = 'SUCCESS'")->fetch_assoc()['sum'];
            ?>
            <div class="stat-card stat-users">
                <h3><?php echo $total_users; ?></h3>
                <p>Total Users</p>
            </div>
            <div class="stat-card stat-projects">
                <h3><?php echo $total_projects; ?></h3>
                <p>Total Projects</p>
            </div>
            <div class="stat-card stat-orders">
                <h3><?php echo $total_orders; ?></h3>
                <p>Total Orders</p>
            </div>
            <div class="stat-card stat-revenue">
                <h3>$<?php echo number_format($total_revenue ?: 0, 2); ?></h3>
                <p>Total Revenue</p>
            </div>
        </div>
        
        <!-- RECENT ORDERS -->
        <div class="admin-panel">
            <h2>Recent Orders</h2>
            <table class="admin-table">
                <thead>
                    <tr>
                        <th>Order ID</th>
                        <th>User Email</th>
                        <th>Project</th>
                        <th>Amount</th>
                        <th>Status</th>
                        <th>Date</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $orders = $conn->query("
                        SELECT o.*, u.email, p.title FROM orders o 
                        JOIN users u ON o.user_id = u.id 
                        JOIN projects p ON o.project_id = p.id 
                        ORDER BY o.created_at DESC LIMIT 20
                    ");
                    
                    while ($order = $orders->fetch_assoc()):
                    ?>
                    <tr>
                        <td>#<?php echo $order['id']; ?></td>
                        <td><?php echo htmlspecialchars($order['email']); ?></td>
                        <td><?php echo htmlspecialchars($order['title']); ?></td>
                        <td><strong>$<?php echo number_format($order['amount'], 2); ?></strong></td>
                        <td>
                            <?php if ($order['status'] == 'SUCCESS'): ?>
                                <span class="status-badge status-success">✓ Success</span>
                            <?php else: ?>
                                <span class="status-badge status-pending">⏳ Pending</span>
                            <?php endif; ?>
                        </td>
                        <td><?php echo date('M d, Y', strtotime($order['created_at'])); ?></td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
        
        <!-- ALL USERS -->
        <div class="admin-panel">
            <h2>All Users</h2>
            <table class="admin-table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Role</th>
                        <th>Joined</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $users = $conn->query("SELECT * FROM users ORDER BY created_at DESC");
                    
                    while ($user = $users->fetch_assoc()):
                    ?>
                    <tr>
                        <td>#<?php echo $user['id']; ?></td>
                        <td><?php echo htmlspecialchars($user['name']); ?></td>
                        <td><?php echo htmlspecialchars($user['email']); ?></td>
                        <td>
                            <span class="status-badge" style="background: <?php echo $user['role'] == 'admin' ? '#f5576c' : '#667eea'; ?>; color: white;">
                                <?php echo ucfirst($user['role']); ?>
                            </span>
                        </td>
                        <td><?php echo date('M d, Y', strtotime($user['created_at'])); ?></td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
        
        <!-- ALL PROJECTS -->
        <div class="admin-panel">
            <h2>All Projects</h2>
            <table class="admin-table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Title</th>
                        <th>Price</th>
                        <th>Tech Stack</th>
                        <th>Created</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $projects = $conn->query("SELECT * FROM projects ORDER BY created_at DESC");
                    
                    while ($project = $projects->fetch_assoc()):
                    ?>
                    <tr>
                        <td>#<?php echo $project['id']; ?></td>
                        <td><?php echo htmlspecialchars($project['title']); ?></td>
                        <td><strong>$<?php echo number_format($project['price'], 2); ?></strong></td>
                        <td><?php echo htmlspecialchars(substr($project['tech_stack'], 0, 40)); ?>...</td>
                        <td><?php echo date('M d, Y', strtotime($project['created_at'])); ?></td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </div>

    <footer class="footer">
        <p>&copy; 2024 SourceHub - Digital Projects Marketplace. All rights reserved.</p>
    </footer>
</body>
</html>
